//+------------------------------------------------------------------+
//|                                              ModernTimePanel.mq5 |
//|                                      Generated by Boni Darmawan  |
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_plots 0

//--- Inputs (Pilihan posisi dipatenkan di Kanan Atas)
input int               InpOffsetX     = 20;                 // Offset X (Default 20px)
input int               InpOffsetY     = 20;                 // Offset Y (Default 20px)
input color             InpHeaderBG    = clrRoyalBlue;       // Warna Background Header
input color             InpBodyBG      = C'43,43,43';        // Warna Background Body
input color             InpTextColor   = clrWhite;           // Warna Teks
input string            InpFontName    = "Segoe UI";         // Jenis Font
input int               InpFontSize    = 10;                 // Ukuran Font
input color             InptNewBar     = clrLime;            // Warna New Bar

//--- Prefix untuk objek agar mudah dihapus nanti
#define PREFIX "ModernTimePanel_"

//--- Ukuran Panel
int panelWidth = 175;
int headerHeight = 25;
int bodyHeight = 80;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   EventSetTimer(1);
   CreateDashboard();
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   EventKillTimer();
   ObjectsDeleteAll(0, PREFIX);
   ChartRedraw(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   UpdatePanel();
   return(rates_total);
  }

//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
   UpdatePanel();
  }

//+------------------------------------------------------------------+
//| Fungsi untuk membuat Dashboard UI                                |
//+------------------------------------------------------------------+
void CreateDashboard()
  {
   int startX = InpOffsetX + panelWidth; 
   
   // 1. Background Header
   CreateRect(PREFIX+"Header", startX, InpOffsetY, panelWidth, headerHeight, InpHeaderBG);
   
   // 2. Background Body
   CreateRect(PREFIX+"Body", startX, InpOffsetY + headerHeight, panelWidth, bodyHeight, InpBodyBG);
   
   // 3. Teks Header (Judul)
   CreateLabel(PREFIX+"Title", "--- Candle Time ---", InpOffsetX + (panelWidth/2), InpOffsetY + 4, InpTextColor, true);
   
   // 4. Teks Body (Label Kiri tanpa titik dua)
   CreateLabel(PREFIX+"LblBroker", "Broker Time", startX - 20, InpOffsetY + headerHeight + 10, InpTextColor, false);
   CreateLabel(PREFIX+"LblLocal", "Local Time", startX - 20, InpOffsetY + headerHeight + 30, InpTextColor, false);
   CreateLabel(PREFIX+"LblNewBar", "New Bar", startX - 20, InpOffsetY + headerHeight + 50, InpTextColor, false);
   
   // 5. Titik Dua (Dibuat terpisah agar sejajar dengan waktu di sebelah kanan)
   CreateLabel(PREFIX+"ColBroker", ":", startX - 95, InpOffsetY + headerHeight + 10, InpTextColor, false);
   CreateLabel(PREFIX+"ColLocal", ":", startX - 95, InpOffsetY + headerHeight + 30, InpTextColor, false);
   CreateLabel(PREFIX+"ColNewBar", ":", startX - 95, InpOffsetY + headerHeight + 50, InpTextColor, false);
   
   // 6. Teks Body (Value Kanan - digeser sedikit agar pas dengan titik dua)
   CreateLabel(PREFIX+"ValBroker", "00:00:00", startX - 105, InpOffsetY + headerHeight + 10, InpTextColor, false);
   CreateLabel(PREFIX+"ValLocal", "00:00:00", startX - 105, InpOffsetY + headerHeight + 30, InpTextColor, false);
   CreateLabel(PREFIX+"ValNewBar", "00:00:00", startX - 105, InpOffsetY + headerHeight + 50, InptNewBar, false); 
  }

//+------------------------------------------------------------------+
//| Fungsi untuk update waktu                                        |
//+------------------------------------------------------------------+
void UpdatePanel()
  {
   datetime brokerTime = TimeCurrent();
   datetime localTime = TimeLocal();
   
   datetime currentBarStart = iTime(_Symbol, _Period, 0);
   int periodSeconds = PeriodSeconds(_Period);
   datetime nextBarTime = currentBarStart + periodSeconds;
   int secondsRemaining = (int)(nextBarTime - brokerTime);
   
   if(secondsRemaining < 0) secondsRemaining = 0;
   
   string strBroker = TimeToString(brokerTime, TIME_SECONDS);
   string strLocal = TimeToString(localTime, TIME_SECONDS);
   string strNewBar = TimeToString((datetime)secondsRemaining, TIME_SECONDS);
   
   ObjectSetString(0, PREFIX+"ValBroker", OBJPROP_TEXT, strBroker);
   ObjectSetString(0, PREFIX+"ValLocal", OBJPROP_TEXT, strLocal);
   ObjectSetString(0, PREFIX+"ValNewBar", OBJPROP_TEXT, strNewBar);
   
   ChartRedraw(0);
  }

//+------------------------------------------------------------------+
//| Helper: Membuat Rectangle Label (Background)                     |
//+------------------------------------------------------------------+
void CreateRect(string name, int x, int y, int width, int height, color bgColor)
  {
   ObjectCreate(0, name, OBJ_RECTANGLE_LABEL, 0, 0, 0);
   ObjectSetInteger(0, name, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, name, OBJPROP_XDISTANCE, x);
   ObjectSetInteger(0, name, OBJPROP_YDISTANCE, y);
   ObjectSetInteger(0, name, OBJPROP_XSIZE, width);
   ObjectSetInteger(0, name, OBJPROP_YSIZE, height);
   ObjectSetInteger(0, name, OBJPROP_BGCOLOR, bgColor);
   ObjectSetInteger(0, name, OBJPROP_BORDER_TYPE, BORDER_FLAT);
   ObjectSetInteger(0, name, OBJPROP_COLOR, bgColor); 
   ObjectSetInteger(0, name, OBJPROP_BACK, false);
   ObjectSetInteger(0, name, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, name, OBJPROP_HIDDEN, true);
  }

//+------------------------------------------------------------------+
//| Helper: Membuat Text Label                                       |
//+------------------------------------------------------------------+
void CreateLabel(string name, string text, int x, int y, color txtColor, bool isCenter)
  {
   ObjectCreate(0, name, OBJ_LABEL, 0, 0, 0);
   ObjectSetInteger(0, name, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, name, OBJPROP_XDISTANCE, x);
   ObjectSetInteger(0, name, OBJPROP_YDISTANCE, y);
   ObjectSetString(0, name, OBJPROP_TEXT, text);
   ObjectSetString(0, name, OBJPROP_FONT, InpFontName);
   ObjectSetInteger(0, name, OBJPROP_FONTSIZE, InpFontSize);
   ObjectSetInteger(0, name, OBJPROP_COLOR, txtColor);
   ObjectSetInteger(0, name, OBJPROP_BACK, false);
   ObjectSetInteger(0, name, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, name, OBJPROP_HIDDEN, true);
   
   if(isCenter)
      ObjectSetInteger(0, name, OBJPROP_ANCHOR, ANCHOR_UPPER);
   else
      ObjectSetInteger(0, name, OBJPROP_ANCHOR, ANCHOR_LEFT_UPPER);
  }